<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActivitiesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('activities', function(Blueprint $table)
		{
			$table->engine = "InnoDB";
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
			$table->increments('id');
			$table->integer('object_id')->unsigned();
			$table->string('object_type', 32)->nullable();
			$table->integer('user_id')->unsigned()->nullable()->index('activities_user_id_foreign_idx');
			$table->integer('customer_id')->unsigned()->nullable()->index('activities_customer_id_foreign_idx');
			$table->string('params', 200)->nullable();
			$table->string('description')->nullable();
			$table->timestamp('created_at')->default(DB::raw('CURRENT_TIMESTAMP'));
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('activities');
	}

}
