<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskCommentsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('task_comments', function(Blueprint $table)
		{
            $table->engine = "InnoDB";
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';
			$table->increments('id');
			$table->text('content', 16777215)->nullable();
			$table->integer('task_id')->unsigned()->index('task_comments_task_id_foreign_idx');
			$table->integer('user_id')->unsigned()->nullable()->index('task_comments_user_id_foreign_idx');
			$table->integer('customer_id')->unsigned()->nullable()->index('task_comments_customer_id_foreign_idx');
			$table->dateTime('created_at')->nullable();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('task_comments');
	}

}
