<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Carbon;

class SaleOrdersTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('sale_orders')->delete();
        
        \DB::table('sale_orders')->insert(array (
            0 => 
            array (
                'id' => 5,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 1,
                'customer_branch_id' => 1,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0002',
                'order_reference_id' => 0,
                'comment' => 'galaxy s10, p30 pro',
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 3.0,
                'other_discount_type' => '%',
                'shipping_charge' => 2.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1806.0,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:07:35',
                'updated_at' => '2020-04-08 13:09:14',
            ),
            1 => 
            array (
                'id' => 6,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 2,
                'customer_branch_id' => 2,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0001',
                'order_reference_id' => 0,
                'comment' => 'apple watch, iPhone 11, alarm clock',
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1462.12,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 2,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:09:19',
                'updated_at' => '2020-04-09 03:13:47',
            ),
            2 => 
            array (
                'id' => 7,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0003',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1734.62,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:32:24',
                'updated_at' => '2020-04-09 03:32:24',
            ),
            3 => 
            array (
                'id' => 9,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 1,
                'customer_branch_id' => 1,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0001',
                'order_reference_id' => 5,
                'comment' => 'galaxy s10, p30 pro',
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 3.0,
                'other_discount_type' => '%',
                'shipping_charge' => 2.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1806.0,
                'paid' => 60.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:13:35',
                'updated_at' => '2020-04-15 13:05:33',
            ),
            4 => 
            array (
                'id' => 10,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0002',
                'order_reference_id' => 7,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1734.62,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:13:56',
                'updated_at' => '2020-04-08 13:04:04',
            ),
            5 => 
            array (
                'id' => 13,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0006',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 133.27,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:17:08',
                'updated_at' => '2020-04-08 13:07:19',
            ),
            6 => 
            array (
                'id' => 14,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0003',
                'order_reference_id' => 13,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 133.27,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:17:08',
                'updated_at' => '2020-04-08 13:07:18',
            ),
            7 => 
            array (
                'id' => 15,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 2,
                'customer_branch_id' => 2,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0007',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 8.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1430.46,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:18:47',
                'updated_at' => '2020-04-08 13:09:41',
            ),
            8 => 
            array (
                'id' => 16,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 2,
                'customer_branch_id' => 2,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0004',
                'order_reference_id' => 15,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 8.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1430.46,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:18:47',
                'updated_at' => '2020-04-08 13:09:41',
            ),
            9 => 
            array (
                'id' => 17,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 5,
                'customer_branch_id' => 5,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0008',
                'order_reference_id' => 0,
                'comment' => 'phone and blendar',
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3735.32,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:20:35',
                'updated_at' => '2020-04-09 03:34:36',
            ),
            10 => 
            array (
                'id' => 18,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 5,
                'customer_branch_id' => 5,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0005',
                'order_reference_id' => 17,
                'comment' => 'phone and blendar',
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3735.32,
                'paid' => 3735.32,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:20:35',
                'updated_at' => '2020-04-15 13:11:43',
            ),
            11 => 
            array (
                'id' => 21,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 1,
                'customer_branch_id' => 1,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0009',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3509.87,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:23:37',
                'updated_at' => '2020-04-08 13:11:47',
            ),
            12 => 
            array (
                'id' => 22,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 1,
                'customer_branch_id' => 1,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0006',
                'order_reference_id' => 21,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3509.87,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:23:37',
                'updated_at' => '2020-04-08 13:11:47',
            ),
            13 => 
            array (
                'id' => 25,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0010',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3670.02,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:25:34',
                'updated_at' => '2020-04-09 03:08:23',
            ),
            14 => 
            array (
                'id' => 26,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0007',
                'order_reference_id' => 25,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3670.02,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-08 12:25:34',
                'updated_at' => '2020-04-09 03:08:23',
            ),
            15 => 
            array (
                'id' => 33,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0011',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1669.61,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:10:32',
                'updated_at' => '2020-04-09 03:10:32',
            ),
            16 => 
            array (
                'id' => 34,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 4,
                'customer_branch_id' => 4,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0008',
                'order_reference_id' => 33,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 4,
                'exchange_rate' => 0.65,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 10.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1669.61,
                'paid' => 1669.61,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:10:32',
                'updated_at' => '2020-04-15 13:10:58',
            ),
            17 => 
            array (
                'id' => 35,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0012',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1739.7,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:11:25',
                'updated_at' => '2020-04-09 03:11:25',
            ),
            18 => 
            array (
                'id' => 36,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0009',
                'order_reference_id' => 35,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1739.7,
                'paid' => 775.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:11:25',
                'updated_at' => '2020-04-15 13:12:59',
            ),
            19 => 
            array (
                'id' => 37,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 2,
                'customer_branch_id' => 2,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0013',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 8.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1430.46,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:12:00',
                'updated_at' => '2020-04-09 03:12:00',
            ),
            20 => 
            array (
                'id' => 38,
                'transaction_type' => 'SALESINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Invoice',
                'project_id' => NULL,
                'customer_id' => 2,
                'customer_branch_id' => 2,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'INV-0010',
                'order_reference_id' => 37,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 2,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 1.0,
                'other_discount_type' => '%',
                'shipping_charge' => 8.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 1430.46,
                'paid' => 1430.46,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:12:00',
                'updated_at' => '2020-04-15 13:10:21',
            ),
            21 => 
            array (
                'id' => 39,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0004',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3038.75,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:14:14',
                'updated_at' => '2020-04-09 03:35:58',
            ),
            22 => 
            array (
                'id' => 40,
                'transaction_type' => 'SALESORDER',
                'invoice_type' => 'quantity',
                'order_type' => 'Direct Order',
                'project_id' => NULL,
                'customer_id' => 3,
                'customer_branch_id' => 3,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'QN-0014',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 1,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 3,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 3,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 0,
                'has_hsn' => 0,
                'has_other_discount' => 1,
                'has_shipping_charge' => 1,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => NULL,
                'custom_charge_amount' => 0.0,
                'total' => 3038.75,
                'paid' => 0.0,
                'amount_received' => NULL,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => NULL,
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-09 03:14:51',
                'updated_at' => '2020-04-09 03:16:56',
            ),
            23 => 
            array (
                'id' => 42,
                'transaction_type' => 'POSINVOICE',
                'invoice_type' => 'quantity',
                'order_type' => 'directPOS',
                'project_id' => NULL,
                'customer_id' => 1,
                'customer_branch_id' => 1,
                'user_id' => 1,
                'tax_type' => 'exclusive',
                'reference' => 'POS-0001',
                'order_reference_id' => 0,
                'comment' => NULL,
                'has_comment' => 0,
                'order_date' => \Carbon::now()->subDays(7)->toDateTimeString(),
                'due_date' => \Carbon::now()->toDateTimeString(),
                'location_id' => 1,
                'payment_method_id' => NULL,
                'discount_on' => 'before',
                'currency_id' => 1,
                'exchange_rate' => 1.0,
                'has_tax' => 1,
                'has_description' => 1,
                'has_item_discount' => 1,
                'has_hsn' => 0,
                'has_other_discount' => 0,
                'has_shipping_charge' => 0,
                'has_custom_charge' => 0,
                'other_discount_amount' => 0.0,
                'other_discount_type' => '%',
                'shipping_charge' => 0.0,
                'custom_charge_title' => '',
                'custom_charge_amount' => 0.0,
                'total' => 2503.515,
                'paid' => 2503.515,
                'amount_received' => 2503.515,
                'payment_term_id' => 1,
                'pos_invoice_status' => 'clear',
                'pos_discount_amount' => 0.0,
                'pos_order_title' => 'Unknown',
                'pos_tax_on_order' => 0.0,
                'pos_shipping' => NULL,
                'created_at' => '2020-04-15 12:40:50',
                'updated_at' => '2020-04-15 12:40:50',
            ),
        ));
        
        
    }
}